﻿
using System;
using System.Collections.Generic;
using System.Text;

namespace PI.ZB.N1200.ELearning.BL.DBD
{
    internal class CompetencePart : PI.FM.N000.Base.BL.DBD.BaseTable<BO.CompetencePart>
    {
        #region Static factory
        private static CompetencePart _factory = null;

        public static CompetencePart DBD
        {
            get
            {
                if (_factory == null)
                {
                    _factory = new CompetencePart();
                }
                return _factory;
            }
        }
        #endregion

        #region Override - Initialization
        protected override void InitializeTableName()
        {
            _tableName = "PIZB1200_CompetencePart";
        }

        protected override void InitializeProperties()
        {
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("CompetenceID", "CompetenceID"));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("Name", "Name",true));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("Abbreviation", "Abbreviation"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("Weight", "Weight"));
            Add(new PI.FM.N000.Base.BL.DBD.BoolProperty("IsActive", "IsActive"));
            Add(new PI.FM.N000.Base.BL.DBD.BoolProperty("IsValid", "IsValid"));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("Description", "Description"));
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("ImageFileID", "ImageFileID"));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("ImageFileURL", "ImageFileURL"));  
 
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("CompetenceCourseID", "CompetenceCourseID"));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("CompetenceCourseAbbreviation", "CompetenceCourseAbbreviation"));
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("CompetenceCourseImageFileID", "CompetenceCourseImageFileID"));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("CompetenceCourseImageFileURL", "CompetenceCourseImageFileURL"));
            Add(new PI.FM.N000.Base.BL.DBD.DecimalProperty("CompetenceCourseRandomizePercent", "CompetenceCourseRandomizePercent"));

            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("CompetenceTheoryID", "CompetenceTheoryID"));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("CompetenceTheoryAbbreviation", "CompetenceTheoryAbbreviation"));
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("CompetenceTheoryImageFileID", "CompetenceTheoryImageFileID"));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("CompetenceTheoryImageFileURL", "CompetenceTheoryImageFileURL"));

            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("CaseID", "CaseID"));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("CaseAbbreviation", "CaseAbbreviation"));
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("CaseImageFileID", "CaseImageFileID"));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("CaseImageFileURL", "CaseImageFileURL"));
            Add(new PI.FM.N000.Base.BL.DBD.DecimalProperty("CaseRandomizePercent", "CaseRandomizePercent"));
        }
        #endregion

    #region Commands definition
    public enum Commands
    {
      RestoreBySearch   = 10,
      CountBySearch     = 11,
      RestoreByStudent  = 12
    }
    #endregion

    #region Get Commands
    protected override Gemini.Core.BL.Interface.DBD.ICommand DoGetCommand(int CommandID)
    {
      switch (CommandID)
      {
          case (int)Commands.RestoreBySearch: return new Command_RestoreBySearch();
          case (int)Commands.CountBySearch: return new Command_CountBySearch();
          case (int)Commands.RestoreByStudent: return new Command_RestoreByStudent();
      }
      
      return base.DoGetCommand(CommandID);
    }
    #endregion

    #region Additional Commands Classes
    class Command_RestoreBySearch : PI.FM.N000.Base.BL.DBD.BaseCommand<BO.CompetencePart>
    {
        public Command_RestoreBySearch() : base(PI.ZB.N1200.ELearning.BL.DBD.CompetencePart.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

      protected override void InitializeParametrs()
      {
        Add(new Gemini.Core.BL.DBD.Param("CompetenceID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
        Add(new Gemini.Core.BL.DBD.Param("IsActive", Gemini.Core.BL.DAL.SqlTypes.Bit));
        Add(new Gemini.Core.BL.DBD.Param("IsValid", Gemini.Core.BL.DAL.SqlTypes.BigInt));
      }

      protected override void InitializeCommandText()
      {
          _commandText = "PIZB1200_CompetencePart_RestoreBySearch";
      }
    }

    class Command_CountBySearch : PI.FM.N000.Base.BL.DBD.BaseCommand<BO.CompetencePart>
    {
        public Command_CountBySearch() : base(PI.ZB.N1200.ELearning.BL.DBD.CompetencePart.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

        protected override void InitializeParametrs()
        {
            Add(new Gemini.Core.BL.DBD.Param("CompetenceID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
            Add(new Gemini.Core.BL.DBD.Param("IsActive", Gemini.Core.BL.DAL.SqlTypes.Bit));
            Add(new Gemini.Core.BL.DBD.Param("IsValid", Gemini.Core.BL.DAL.SqlTypes.BigInt));
            Add(new Gemini.Core.BL.DBD.Param("Result", null, Gemini.Core.BL.DAL.SqlTypes.Int, System.Data.ParameterDirection.Output));
        }

        protected override void InitializeCommandText()
        {
            _commandText = "PIZB1200_CompetencePart_CountBySearch";
        }
    }

    class Command_RestoreByStudent : PI.FM.N000.Base.BL.DBD.BaseCommand<BO.CompetencePart>
    {
        public Command_RestoreByStudent() : base(PI.ZB.N1200.ELearning.BL.DBD.CompetencePart.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

        protected override void InitializeParametrs()
        {
            Add(new Gemini.Core.BL.DBD.Param("StudentID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
        }

        protected override void InitializeCommandText()
        {
            _commandText = "PIZB1200_CompetencePart_RestoreByStudent";
        }
    }
    #endregion
    }
}
